<?php
require_once 'config.php';
require_once 'header.php';

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Get user data
$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();
?>

<div class="container">
    <div class="row mt-5">
        <!-- Sidebar -->
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <img src="assets/profile/<?= $user['profile_pic'] ?? 'default.jpg' ?>" 
                         class="rounded-circle mb-3" width="120" height="120">
                    <h5><?= htmlspecialchars($user['full_name']) ?></h5>
                    <p class="text-muted"><?= ucfirst($user['user_type']) ?></p>
                    <div class="list-group">
                        <a href="dashboard.php" class="list-group-item list-group-item-action active">Dashboard</a>
                        <a href="edit-profile.php" class="list-group-item list-group-item-action">Edit Profile</a>
                        <a href="my-gigs.php" class="list-group-item list-group-item-action">My Gigs</a>
                        <a href="logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="col-md-9">
            <?php if ($user['user_type'] === 'client'): ?>
                <!-- Client Dashboard -->
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5>Posted Gigs</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $gigs = $conn->query("SELECT * FROM gigs WHERE user_id=$user_id");
                        if ($gigs->num_rows > 0):
                        ?>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Title</th>
                                        <th>Budget</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($gig = $gigs->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= substr(htmlspecialchars($gig['title']), 0, 30) ?></td>
                                        <td>$<?= $gig['budget'] ?></td>
                                        <td><span class="badge bg-<?= $gig['status'] === 'open' ? 'success' : 'secondary' ?>">
                                            <?= $gig['status'] ?>
                                        </span></td>
                                        <td>
                                            <a href="gig.php?id=<?= $gig['id'] ?>" class="btn btn-sm btn-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                            <div class="alert alert-info">No gigs posted yet</div>
                        <?php endif; ?>
                        <a href="create-gig.php" class="btn btn-success">
                            <i class="fas fa-plus"></i> Post New Gig
                        </a>
                    </div>
                </div>

            <?php else: ?>
                <!-- Freelancer Dashboard -->
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5>Available Gigs</h5>
                    </div>
                    <div class="card-body">
                        <!-- Add freelance-specific content -->
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>