<?php
require_once 'config.php';

// Verify user is logged in and is a client
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'client') {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id']; // Define user_id from session

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Escape and validate inputs
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $category = $conn->real_escape_string($_POST['category']);
    $budget = (float)$_POST['budget'];
    $deadline = $conn->real_escape_string($_POST['deadline']);
    
    // File upload handling
    $target_dir = __DIR__ . "/assets/uploads/gigs/";
    if (!file_exists($target_dir)) {
        mkdir($target_dir, 0755, true);
    }
    
    $file_path = '';
    if (!empty($_FILES["attachment"]["name"])) {
        $original_name = basename($_FILES["attachment"]["name"]);
        $clean_name = preg_replace("/[^a-zA-Z0-9\.]/", "_", $original_name);
        $file_name = uniqid() . '_' . $clean_name;
        $target_file = $target_dir . $file_name;
        
        if (move_uploaded_file($_FILES["attachment"]["tmp_name"], $target_file)) {
            $file_path = $conn->real_escape_string("assets/uploads/gigs/" . $file_name);
        }
    }

    // SQL with proper value formatting
    $sql = "INSERT INTO gigs (
            user_id, 
            title, 
            description, 
            category, 
            budget, 
            deadline, 
            attachment
        ) VALUES (
            '$user_id', 
            '$title', 
            '$description', 
            '$category', 
            $budget, 
            '$deadline', 
            " . ($file_path ? "'$file_path'" : "NULL") . "
        )";

    if ($conn->query($sql)) {
        header("Location: dashboard.php");
        exit;
    } else {
        die("Error: " . $conn->error);
    }
}
?>
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Post New Gig</h4>
                </div>
                <div class="card-body">
                    <form method="post" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label>Gig Title</label>
                            <input type="text" name="title" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="5" required></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label>Category</label>
                                <select name="category" class="form-select" required>
                                    <option value="Writing">Writing</option>
                                    <option value="Design">Design</option>
                                    <option value="Programming">Programming</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Budget ($)</label>
                                <input type="number" name="budget" class="form-control" step="0.01" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label>Deadline</label>
                                <input type="date" name="deadline" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Attachment (Optional)</label>
                                <input type="file" name="attachment" class="form-control">
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Post Gig</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>